#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
using namespace std;

struct Dogadaj {
    double vreme;
    int trkac1, trkac2;
    Dogadaj(double v, int t1, int t2) : vreme(v), trkac1(t1), trkac2(t2) {}
    bool operator<(const Dogadaj& d) const {
        return vreme > d.vreme;
    }
};

double izracunajVremePreticanja(pair<int, int>& prvi, pair<int, int>& drugi) {
    if (prvi.second <= drugi.second) return -1;
    return (double)(drugi.first - prvi.first) / (prvi.second - drugi.second);
}

int main() {
    int N;
    long long K;
    cin >> N >> K;

    vector<pair<int, int>> trkaci(N);
    for (int i = 0; i < N; ++i) {
        cin >> trkaci[i].first >> trkaci[i].second;
    }

    sort(trkaci.begin(), trkaci.end(), [](const pair<int, int>& a, const pair<int, int>& b) {
        return a.second > b.second;
    });

    priority_queue<Dogadaj> dogadaji;
    for (int i = 0; i < N; ++i) {
        for (int j = i + 1; j < N; ++j) {
            double vremePreticanja = izracunajVremePreticanja(trkaci[i], trkaci[j]);
            if (vremePreticanja != -1) {
                dogadaji.push(Dogadaj(vremePreticanja, i, j));
            }
        }
    }

    double vremeKPreticanja = -1;
    for (int i = 0; i < K && !dogadaji.empty(); ++i) {
        vremeKPreticanja = dogadaji.top().vreme;
        dogadaji.pop();
    }

    cout.precision(9);
    cout << fixed << vremeKPreticanja << endl;

    return 0;
}